#include "StdAfx.h"
#include "BaseWindow.h"

//------------------------------------------------------------------------
//--> CLASS bWindow
//------------------------------------------------------------------------
bool bWindow::Create ()
{
	// we'll just assume CreateWindowEx ()'s parameters are protected members of AbstractWindow
	_hwnd = ::CreateWindowEx (
			_styleEx,
			_className,
			_windowName,
			_style,
			_x,
			_y,
			_width,
			_height,
			_hwndParent,
			_hMenu,
			_hInstance,
			this			// pointer to this class instance
		);
 
	if (!_hwnd) return false;
	else 
	{
		LoadControls();
		return true;	
	}
}


LRESULT CALLBACK bWindow::msgRouter (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	bWindow *wnd = 0;	// pointer to the window that should receive the message
 
	if (message == WM_NCCREATE) {	
		// if this message gets sent then a new window has just been created, 
		// so we'll asociate its handle with its AbstractWindow instance pointer
		::SetWindowLong (hwnd, GWL_USERDATA, long((LPCREATESTRUCT(lParam))->lpCreateParams));
	}
 
	// --- messages different from WN_NCCREATE / or WM_NCCREATE was just processed ---
	// we retrieve the instance of AbstractWindow that corresponds to the destination window's HWND
	wnd = (bWindow *) (::GetWindowLong (hwnd, GWL_USERDATA));
 
	// we then route the message to the wndProc method defined in the derived AbstractWindow class
	if (wnd)
	{
		wnd->wndProc (hwnd, message, wParam, lParam);
	}
	else
		// for messages that arrive prior to WM_NCCREATE 
		// and the HWND <-> AbstractWindow * association was not made
		return ::DefWindowProc (hwnd, message, wParam, lParam);
}


//------------------------------------------------------------------------
//--> CLASS bWindowClass
//------------------------------------------------------------------------

bWindowClass::bWindowClass (HINSTANCE hInst, const TCHAR *className)
{
	// could've used GetModuleHandle (NULL) instead of passing the instance as a parameter
	hInstance = hInst;				
	// all messages for windows belonging to this Window Class will get sent to msgRouter
	lpfnWndProc = bWindow::msgRouter;	
	lpszClassName = className;
 
	// --- set default values for the rest of the WNDCLASSEX structure ---
	// --- later you can derive your own class and modify this behavior ---
	lpszMenuName = 0;
	cbSize = sizeof (WNDCLASSEX);
	cbClsExtra = 0;
	cbWndExtra = 0;
	style = CS_DBLCLKS;
	hIcon = ::LoadIcon (NULL, IDI_APPLICATION);
	hIconSm = ::LoadIcon (NULL, IDI_APPLICATION);
	hCursor = ::LoadCursor (NULL, IDC_ARROW);
	hbrBackground = NULL;//(HBRUSH) ::GetStockObject (COLOR_BTNFACE);	
 
	// --- the constructor won't call the Register () member function ---
	// --- that was my choice, again, you can change the behavior in your code ---
}
 
bool bWindowClass::Register ()
{
	if (::RegisterClassEx (this)) // we pass the this pointer because our class inherits from WNDCLASSEX
		return true;
	else 
		return false;
}